from django.urls import path
from . import views

urlpatterns = [
    # Existing endpoints
    path("", views.ExperienceListView.as_view(), name="experience-list"),
    path("<int:pk>/", views.ExperienceDetailView.as_view(), name="experience-detail"),
    path("update/<int:pk>/", views.UpdateExperienceView.as_view(), name="experience-update"),
    path("delete/<int:pk>/", views.DeleteExperienceView.as_view(), name="experience-delete"),

    # Public fetch all experiences endpoint
    path("all/", views.FetchAllExperiencesView.as_view(), name="fetch-all-experiences"),

# Public fetch single experience endpoint
    path("single/<int:pk>/", views.FetchSingleExperienceView.as_view(), name="fetch-single-experience"),
    # Booking endpoints
    path("bookings/", views.BookingListView.as_view(), name="booking-list"),
    path("bookings/<int:pk>/", views.BookingDetailView.as_view(), name="booking-detail"),
]
