from rest_framework import viewsets
from .models import Gallery
from .serializers import GallerySerializer
from rest_framework.permissions import AllowAny

class GalleryViewSet(viewsets.ModelViewSet):   # ✅ Must be ModelViewSet
    queryset = Gallery.objects.all().order_by("-uploaded_at")
    serializer_class = GallerySerializer
    permission_classes = [AllowAny]
