from django.db import models


class Invoice(models.Model):
    hotel_name = models.CharField(max_length=255)
    booking_details = models.TextField(blank=True, null=True)
    check_in = models.DateField(blank=True, null=True)   # ✅ now optional
    check_out = models.DateField(blank=True, null=True)  # ✅ now optional
    room_details = models.CharField(max_length=255)
    guest_details = models.CharField(max_length=255)
    hotel_link = models.URLField(blank=True, null=True)
    created_at = models.DateTimeField(auto_now_add=True)

    def __str__(self):
        return f"Invoice #{self.id} - {self.hotel_name} ({self.guest_details})"
