from rest_framework import viewsets
from rest_framework.permissions import BasePermission, SAFE_METHODS
from .models import Package
from .serializers import PackageSerializer


class ReadOnlyOrIsAuthenticated(BasePermission):
    """
    Allow GET/HEAD/OPTIONS requests for anyone,
    require authentication for POST/PUT/PATCH/DELETE.
    """
    def has_permission(self, request, view):
        if request.method in SAFE_METHODS:
            return True
        return request.user and request.user.is_authenticated


class PackageViewSet(viewsets.ModelViewSet):
    """
    ViewSet for handling travel packages with nested itinerary days.
    """
    queryset = Package.objects.all().order_by("-created_at")
    serializer_class = PackageSerializer
    permission_classes = [ReadOnlyOrIsAuthenticated]
